var toastMixin = Swal.mixin({
    toast: true,
    icon: 'success',
    title: 'General Title',
    animation: false,
    position: 'top-right',
    showConfirmButton: false,
    timer: 2500,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
});

function successToast(message) {
    toastMixin.fire({
        animation: true,
        title: message
    });
}

function errorToast(message) {
    toastMixin.fire({
        title: message,
        icon: 'error'
    });
}