@extends('layout.app')
@section('title', 'Support')


@section('content')
    <main class="support-main">
        <section class="support-section">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="support-top">
                            <h2 class="section-title text-center text-white">Dedicated Support for All Your VPN Needs</h2>
                            <p class="para">Find quick answers and expert guidance to optimize your experience.</p>
                            <div class="support-search-area">
                                <img class="img-fluid" src="{{ asset(path: 'themes/images/search-icon.svg') }}" alt="search">
                                <input type="text" class="support-search" placeholder="Search for articles, guides, or Solutions...." name="" id="">
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="browse-knowledge-main">
                            <h2 class="section-sb-title text-capitalize">Browse our Knowledge Base</h2>
                            <div class="row">
                                <div class="col-12 col-lg-6">
                                    <div class="browse-box mb-23px">
                                        <div class="browse-box-top">
                                            <img class="img-fluid" src="{{ asset(path: 'themes/images/browse-icon-1.svg') }}" alt="">
                                            <h6 class="browse-box-title">Setup Guides</h6>
                                            <p class="browse-box-para m-0">Get started with installing and configuring TwistVPN on your devices.</p>
                                        </div>
                                        <div class="browse-box-top">
                                            <span class="article-count">25 articles</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="browse-box mb-23px">
                                        <div class="browse-box-top">
                                            <img class="img-fluid" src="{{ asset(path: 'themes/images/browse-icon-2.svg') }}" alt="">
                                            <h6 class="browse-box-title">VPN Tutorials</h6>
                                            <p class="browse-box-para m-0">Learn advanced usage, manual configurations, and optimization tips.</p>
                                        </div>
                                        <div class="browse-box-top">
                                            <span class="article-count">25 articles</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="browse-box">
                                        <div class="browse-box-top">
                                            <img class="img-fluid" src="{{ asset(path: 'themes/images/browse-icon-3.svg') }}" alt="">
                                            <h6 class="browse-box-title">FAQ</h6>
                                            <p class="browse-box-para m-0">Frequently asked questions about TwistVPN services, features, and policies.</p>
                                        </div>
                                        <div class="browse-box-top">
                                            <span class="article-count">25 articles</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6">
                                    <div class="browse-box">
                                        <div class="browse-box-top">
                                            <img class="img-fluid" src="{{ asset(path: 'themes/images/browse-icon-4.svg') }}" alt="">
                                            <h6 class="browse-box-title">Account & Billing</h6>
                                            <p class="browse-box-para m-0">Manage your subscription, payments, personal information, and account settings.</p>
                                        </div>
                                        <div class="browse-box-top">
                                            <span class="article-count">25 articles</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="need-help-main">
                            <h2 class="section-sb-title mb-4 text-white">Need More Help?</h2>
                            <p class="sm-para">If you can't find what you're looking for in our knowledge base, our dedicated <br> support team is ready to assist you.</p>
                            <div class="text-center">
                                <a class="supp-mail-cta" href="mailto:support@twistvpn.com">support@twistvpn.com</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="online-freedom-box">
                            <h2 class="section-sb-title mb-4">Ready to Experience True Online Freedom?</h2>
                            <p class="sm-para">Join thousands of satisfied users who trust TwistVPN for their online <br> privacy and security.</p>
                            <div class="text-center">
                                <a class="secondary-btn2 mb-0" href="javascript:void(0)">Get TwistVPN</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection


@push('script')
@endpush